import 'package:flutter/material.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/common/widget/html_viewer.dart';
import 'package:mighty_school/feature/landing_page/frontend_course/domain/model/my_course_model.dart';
import 'package:mighty_school/helper/price_converter.dart';
import 'package:mighty_school/helper/route_helper.dart';
import 'package:mighty_school/util/app_constants.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';
import 'package:get/get.dart';
import 'dart:math';

class CourseItemCardWidget extends StatefulWidget {
  final CourseItem? courses;
  const CourseItemCardWidget({super.key, required this.courses});

  @override
  State<CourseItemCardWidget> createState() => _CourseItemCardWidgetState();
}

class _CourseItemCardWidgetState extends State<CourseItemCardWidget>
    with SingleTickerProviderStateMixin {

  late AnimationController _controller;

  @override
  void initState() {
    super.initState();
    _controller = AnimationController(duration: const Duration(milliseconds: 400), vsync: this,);
  }

  @override
  void dispose() {
    _controller.dispose();
    super.dispose();
  }

  void _hover(bool value) {
    value ? _controller.forward() : _controller.reverse();
  }

  @override
  Widget build(BuildContext context) {
    return MouseRegion(onEnter: (_) => _hover(true), onExit: (_) => _hover(false),
      child: SizedBox(width: 520, child: Stack(alignment: Alignment.center, children: [
        AnimatedBuilder(animation: _controller, builder: (_, child) {
          final rotation = _controller.value * pi;
          return Opacity(opacity: rotation <= pi / 2 ? 1 : 0,
            child: Transform(alignment: Alignment.center,
              transform: Matrix4.identity()
                ..setEntry(3, 2, 0.001)
                ..rotateY(rotation),
              child: child));
          },
          child: _front(context)),

        AnimatedBuilder(animation: _controller, builder: (_, child) {
          final rotation = pi + (_controller.value * pi);
          return Opacity(opacity: _controller.value > 0.5 ? 1 : 0,
            child: Transform(alignment: Alignment.center,
              transform: Matrix4.identity()
                ..setEntry(3, 2, 0.001)
                ..rotateY(rotation),
              child: child));
          },
          child: _back(context)),
      ])),
    );
  }

  Widget _front(BuildContext context) {
    return _cardWrapper(context, child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
      _image(),
      Padding(padding: const EdgeInsets.fromLTRB(Dimensions.paddingSizeDefault,Dimensions.paddingSizeSmall, Dimensions.paddingSizeDefault,0),
        child: Text(widget.courses?.title ?? '', maxLines: 1,
            overflow: TextOverflow.ellipsis,
          style: textBold.copyWith(fontSize: Dimensions.fontSizeLarge))),

      Padding(padding: const EdgeInsets.fromLTRB(Dimensions.paddingSizeDefault,Dimensions.paddingSizeSmall, Dimensions.paddingSizeDefault, Dimensions.paddingSizeDefault),
        child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
            (widget.courses?.paymentType == "free")?
            Text("free".tr, style: textBold.copyWith(fontSize: Dimensions.fontSizeLarge,
                color: Theme.of(context).primaryColor)) :
            Row(spacing: Dimensions.paddingSizeSmall, children: [
              Text(PriceConverter.convertPrice(context, widget.courses?.regularPrice ?? 0),
                  style: textRegular.copyWith(decoration: TextDecoration.lineThrough)),
              const SizedBox(width: Dimensions.paddingSizeExtraSmall),
              Text(PriceConverter.convertPrice(context, widget.courses?.offerPrice ?? 0),
                  style: textBold.copyWith(fontSize: Dimensions.fontSizeLarge)),
            ]),
          ]))
        ],
      ),
    );
  }

  Widget _back(BuildContext context) {
    return _cardWrapper(context,
      child: Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
        child: Column(mainAxisAlignment: MainAxisAlignment.center,spacing: Dimensions.paddingSizeSmall, children: [
          Text(widget.courses?.title ?? '',
            textAlign: TextAlign.center, style: textBold.copyWith(fontSize: Dimensions.fontSizeLarge),),

          HtmlViewer(htmlText: widget.courses?.description ?? ''),
          CustomButton(onTap: (){}, text: "add_to_cart".tr)
          ],
        ),
      ),
    );
  }


  Widget _image() {
    return SizedBox(height: 205, width: 520,
      child: ClipRRect(borderRadius: const BorderRadius.vertical(top: Radius.circular(Dimensions.paddingSizeSmall)),
        child: CustomImage(image: "${AppConstants.baseUrl}/storage/courses/${widget.courses?.image}"),
      ),
    );
  }

  Widget _cardWrapper(BuildContext context, {required Widget child}) {
    return CustomContainer(showShadow: false,horizontalPadding: 0,verticalPadding: 0,
      onTap: (){
        Get.toNamed(RouteHelper.getFrontendCourseDetailsRoute(widget.courses?.slug ?? ''));
      },
      child: child,
    );
  }
}