import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/feature/landing_page/domain/models/ready_to_join_us_model.dart';
import 'package:mighty_school/feature/landing_page/logic/landing_page_controller.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/admission_loading_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/images.dart';
import 'package:mighty_school/util/styles.dart';

class AdmissionsWidget extends StatelessWidget {
  const AdmissionsWidget({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<LandingPageController>(
      initState: (state) {
        final landingPageController = Get.find<LandingPageController>();
        if (landingPageController.admissionModel == null) {
          landingPageController.getAdmissionData();
        }
      },
      builder: (landingPageController) {
        ReadyToJoinUsModel? readyToJoinUsModel = landingPageController.admissionModel;
        final isDesktop = ResponsiveHelper.isDesktop(context);
        return readyToJoinUsModel != null?
        Center(child: SizedBox(width: Dimensions.webMaxWidth,
            child: Padding(padding: EdgeInsets.symmetric(vertical:ResponsiveHelper.isDesktop(context)?50 : Dimensions.paddingSizeDefault),
              child: isDesktop ? Row(crossAxisAlignment: CrossAxisAlignment.center,mainAxisAlignment: MainAxisAlignment.center,children: [
                  Expanded(child: Column( mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.center, children: [
                        Text("admissions".tr, style: textMedium.copyWith(color: Theme.of(context).primaryColor, fontSize: 20)),
                        const SizedBox(height: 8),
                        Text("ready_to_join_us".tr,
                          style: textBold.copyWith(fontSize: 40, color: Theme.of(context).colorScheme.primary,),),
                        const SizedBox(height: 10),
                        Container(height: 3, width: 60,
                          decoration: BoxDecoration(color: Theme.of(context).primaryColor,
                            borderRadius: BorderRadius.circular(50))),
                        const SizedBox(height: 20),
                        ListView.builder(
                          itemCount: readyToJoinUsModel.data?.length ?? 0,
                          shrinkWrap: true,
                          physics: const NeverScrollableScrollPhysics(),
                          padding: EdgeInsets.zero,
                          itemBuilder: (context, index) {
                            return ReadyToJoinUsItemWidget(item: readyToJoinUsModel.data?[index]);
                          },
                        ),
                      ],
                    ),
                  ),
                ],
              ) :
              Column(crossAxisAlignment: CrossAxisAlignment.center, children: [
                  Text("admissions".tr,style: textMedium.copyWith(color: Theme.of(context).primaryColor,fontSize: 20,),),
                  const SizedBox(height: 8),
                  Text("ready_to_join_us".tr,style: textBold.copyWith(fontSize: 36,color: Theme.of(context).colorScheme.primary,),textAlign: TextAlign.center,),
                  const SizedBox(height: 10),
                  Container(height: 3, width: 60, decoration: BoxDecoration(color: Theme.of(context).primaryColor, borderRadius: BorderRadius.circular(50),)),
                  const SizedBox(height: 20),
                  ListView.builder(
                    itemCount: readyToJoinUsModel.data?.length ?? 0,
                    shrinkWrap: true,
                    physics: const NeverScrollableScrollPhysics(),
                    padding: EdgeInsets.zero,
                    itemBuilder: (context, index) {
                      return ReadyToJoinUsItemWidget(
                        item: readyToJoinUsModel.data?[index],
                      );
                    },
                  ),
                ],
              ),
            ),
          ),
        ):const AdmissionWidgetLoadingWidget();
      },
    );
  }
}



class ReadyToJoinUsItemWidget extends StatelessWidget {
  final ReadyToJoinUsItem? item;
  const ReadyToJoinUsItemWidget({super.key, this.item});

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: Dimensions.paddingSizeSmall),
      child: CustomContainer( showShadow: false, borderRadius: Dimensions.radiusSmall,
        border: Border.all(width: .25, color: Theme.of(context).primaryColorDark.withValues(alpha: 0.1)),
        child: Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
            CustomImage(image: item?.icon, height: 50,width: 50, placeholder: Images.program),
            const SizedBox(width: 20,),
             Expanded(
               child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
                 Text(item?.title??'',style: textRegular.copyWith(fontSize: Dimensions.fontSizeLarge)),
                  const SizedBox(height: 8),
                  Text(item?.description??'', style: textRegular.copyWith()),
                  const SizedBox(height: 12),
                   Row(spacing: Dimensions.paddingSizeSmall, children: [
                     Text("Contact Us",style: textRegular.copyWith(color: Theme.of(context).primaryColor),),
                     Icon(Icons.arrow_forward_ios_rounded, color: Theme.of(context).primaryColor, size: 20),]),

                ],
                           ),
             )
          ],
        ),
      ),
    );
  }
}
