import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/confirmation_dialog.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/common/widget/numbering_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_class/domain/model/question_bank_class_model.dart';
import 'package:mighty_school/feature/question_bank/question_bank_class/logic/question_bank_class_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_class/presentation/widgets/create_new_question_bank_class_widget.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';


class QuestionBankClassItemWidget extends StatelessWidget {
  final QuestionBankClassItem? classItem;
  final int index;
  const QuestionBankClassItemWidget({super.key, this.classItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return Row(spacing: Dimensions.paddingSizeDefault, children: [
      NumberingWidget(index: index),
      Expanded(child: Text('${classItem?.name}', style: textRegular.copyWith())),
      EditDeleteSection(horizontal: true, onDelete: (){
        Get.dialog(ConfirmationDialog(
          title: "class",
          content: "are_you_sure_you_want_to_delete_this_class".tr,
          onTap: (){
            Get.back();
            Get.find<QuestionBankClassController>().deleteQuestionBankClass(classItem!.id!);
          },));

      }, onEdit: (){
        Get.dialog(Dialog(shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(Dimensions.paddingSizeSmall)),
            child: CreateNewQuestionBankClassWidget(classItem: classItem)));
      },)
    ],
    );
  }
}
