import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/confirmation_dialog.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/common/widget/numbering_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_subject/domain/model/question_bank_subject_model.dart';
import 'package:mighty_school/feature/question_bank/question_bank_subject/logic/question_bank_subject_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_subject/presentation/widgets/create_new_question_bank_subject_widget.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';


class QuestionBankSubjectItemWidget extends StatelessWidget {
  final QuestionBankSubjectItem? item;
  final int index;
  const QuestionBankSubjectItemWidget({super.key, this.item, required this.index});

  @override
  Widget build(BuildContext context) {
    return Row(spacing: Dimensions.paddingSizeDefault, children: [
      NumberingWidget(index: index),
      Expanded(child: Text('${item?.name}', style: textRegular.copyWith())),
      Expanded(child: Text('${item?.className}', style: textRegular.copyWith())),
      Expanded(child: Text('${item?.groupName}', style: textRegular.copyWith())),
      EditDeleteSection(horizontal: true, onDelete: (){
        Get.dialog(ConfirmationDialog(
          title: "subject",
          content: "subject".tr,
          onTap: (){
            Get.back();
            Get.find<QuestionBankSubjectController>().deleteQuestionBankSubject(item!.id!);
          },));

      }, onEdit: (){
        Get.dialog(Dialog(shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(5)),
          child: CreateNewQuestionBankSubjectWidget(item: item),));
      },)
    ],
    );
  }
}
