import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/layout/list_layout_widget.dart';
import 'package:mighty_school/feature/reports_management/fees_reports/domain/model/unpaid_summery_model.dart';
import 'package:mighty_school/feature/reports_management/fees_reports/logic/fees_reports_controller.dart';
import 'package:mighty_school/feature/reports_management/fees_reports/presentation/widgets/item_widget/unpaid_fees_info_item_widget.dart';
import 'package:mighty_school/feature/reports_management/fees_reports/presentation/widgets/unpaid_search_widget.dart';

class UnpaidFeesInfoReportListWidget extends StatelessWidget {
  final ScrollController scrollController;
  const UnpaidFeesInfoReportListWidget({super.key, required this.scrollController});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<FeesReportsController>(
      builder: (feesReportsController) {
        UnPaidSummeryModel? unPaidSummeryModel = feesReportsController.unpaidSummeryModel;
        return GenericListSection<UnpaidSummery>(
          topWidget: const UnpaidSearchWidget(),
          showAction: false,
          sectionTitle: "fees_reports_management".tr,
          pathItems: ["unpaid_info".tr],
          headings: const ["class", "tot", "total_fee_due", "total_slip_due", "total_due"],
          scrollController: scrollController,
          isLoading: false,
          totalSize: 0,
          offset: 1,
          onPaginate: (offset) async {},
          items: unPaidSummeryModel?.data ?? [],
          itemBuilder: (item, index) => UnpaidFeesInfoItemWidget(item: item, index: index),
        );
      },
    );
  }
}