import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_dropdown.dart';
import 'package:mighty_school/common/widget/custom_snackbar.dart';
import 'package:mighty_school/common/widget/custom_title.dart';
import 'package:mighty_school/feature/academic_configuration/class/controller/class_controller.dart';
import 'package:mighty_school/feature/academic_configuration/class/presentation/widgets/select_class_widget.dart';
import 'package:mighty_school/feature/academic_configuration/section/controller/section_controller.dart';
import 'package:mighty_school/feature/academic_configuration/section/presentation/widgets/select_section_widget.dart';
import 'package:mighty_school/feature/hrm/payroll/controller/payroll_controller.dart';
import 'package:mighty_school/feature/reports_management/fees_reports/logic/fees_reports_controller.dart';
import 'package:mighty_school/util/dimensions.dart';

class UnpaidSearchWidget extends StatelessWidget {
  const UnpaidSearchWidget({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<PayrollController>(builder: (payrollController) {
        return GetBuilder<FeesReportsController>(
          builder: (feesReportController) {
            return Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault),
              child: CustomContainer(
                child: Row(spacing: Dimensions.paddingSizeDefault, crossAxisAlignment: CrossAxisAlignment.end, children: [
                  Expanded(child: Column(children: [
                      const CustomTitle(title: "year"),
                      Padding(padding: const EdgeInsets.symmetric(vertical: 8.0),
                        child: CustomDropdown(width: Get.width, title: "choose_year".tr,
                          items: payrollController.yearList,
                          selectedValue: payrollController.selectedYear,
                          onChanged: (val){
                            payrollController.setSelectedYear(val!);
                          },
                        ),),
                    ],),
                  ),
                  const Expanded(child: SelectClassWidget()),
                  const Expanded(child: SelectSectionWidget()),
                  IntrinsicWidth(
                    child: Padding(
                      padding: const EdgeInsets.only(bottom: 10.0),
                      child: feesReportController.isLoading?
                          const Center(child: CircularProgressIndicator()):
                      CustomButton(onTap: (){
                        if(payrollController.selectedYear == null){
                          showCustomSnackBar("select_year".tr);
                        }else{
                          Get.find<FeesReportsController>().getUnpaidSummary(payrollController.selectedYear.toString(),
                          classId: Get.find<ClassController>().selectedClassItem?.id, sectionId: Get.find<SectionController>().selectedSectionItem?.id);
                        }
                      }, text: "search".tr),
                    ),
                  )
                ]),
              ),
            );
          }
        );
      }
    );
  }
}
