
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/common/widget/custom_popup_menu.dart';
import 'package:mighty_school/common/widget/numbering_widget.dart';
import 'package:mighty_school/feature/students_information/student/domain/model/student_model.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/app_constants.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class AllStudentItemWidget extends StatelessWidget {
  final StudentItem? studentItem;
  final int index;
  const AllStudentItemWidget({super.key, this.studentItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return ResponsiveHelper.isDesktop(context)?
    Row(spacing: Dimensions.paddingSizeSmall, children: [
       NumberingWidget(index: index),
        SizedBox(width: 50, child: Center(child: ClipRRect(borderRadius: BorderRadius.circular(120),
            child: CustomImage(width: 25, height: 25, image: "${AppConstants.baseUrl}/storage/users/${studentItem?.image}" )),)),
        Expanded(child: Text(studentItem?.roll??'', style: textRegular.copyWith(),)),
        Expanded(child: Text("${studentItem?.firstName} ${studentItem?.lastName}", maxLines: 1,overflow: TextOverflow.ellipsis,
          style: textRegular.copyWith(fontSize: Dimensions.fontSizeDefault),)),
        Expanded(child: Text(studentItem?.phone??'', style: textRegular.copyWith(),)),
        Expanded( child: Text(studentItem?.gender??'', style: textRegular.copyWith(),)),
        Expanded(child:  Text(studentItem?.sectionName??'N/A', style: textRegular.copyWith())),
        Expanded(child: Text(studentItem?.className??'N/A', style: textRegular.copyWith(),)),
        Expanded(child: Text(studentItem?.fatherName??'',maxLines: 1,overflow: TextOverflow.ellipsis, style: textRegular.copyWith(),)),
      CustomPopupMenu(menuItems: const [], child: Icon(Icons.more_vert_rounded, color: Theme.of(context).hintColor))
      ]):

    CustomContainer(child: Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
        ClipRRect(borderRadius: BorderRadius.circular(120),
            child: const CustomImage(width: Dimensions.imageSizeBig, height: Dimensions.imageSizeBig, image: "")),
        const SizedBox(width: Dimensions.paddingSizeSmall),
        Expanded(child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
          Text("${studentItem?.name}", style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),),
          Text("${"roll".tr} : ${studentItem?.roll??''}", style: textRegular.copyWith(),),
          Text("${"phone".tr} : ${studentItem?.phone??''}", style: textRegular.copyWith(),),

        ])),
      ],
    ));
  }
}