<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('students', function (Blueprint $table) {
            // New fields (Basic Info)
            $table->string('native_name', 100)->nullable();
            $table->string('nick_name', 50)->nullable();
            $table->string('sect', 100)->nullable();

            // Serial / IDs
            $table->unsignedBigInteger('serial_no')->nullable();
            $table->string('class_id', 20)->nullable();
            $table->string('session_id', 20)->nullable();
            $table->string('section_id', 20)->nullable();

            // Education Info (SSC)
            $table->string('school_name', 150)->nullable();
            $table->string('school_address', 255)->nullable();
            $table->string('board', 50)->nullable();
            $table->string('center', 100)->nullable();
            $table->year('passing_year')->nullable();
            $table->string('ssc_session', 20)->nullable();
            $table->string('board_roll', 30)->nullable();
            $table->string('registration_number', 30)->nullable();
            $table->decimal('gpa_with_4th', 4, 2)->nullable();
            $table->decimal('gpa_without_4th', 4, 2)->nullable();
            $table->unsignedTinyInteger('total_a_plus')->nullable();
            $table->string('subject_4th', 50)->nullable();
            $table->string('grade_4th_sub', 5)->nullable();

            // SSC Grades
            $table->string('bangla', 5)->nullable();
            $table->string('english', 5)->nullable();
            $table->string('math', 5)->nullable();
            $table->string('ict', 5)->nullable();
            $table->string('religion_sub', 5)->nullable();
            $table->string('career_education', 5)->nullable();
            $table->string('physical_education', 5)->nullable();
            $table->string('physics', 5)->nullable();
            $table->string('chemistry', 5)->nullable();
            $table->string('bk', 5)->nullable();
            $table->string('biology', 5)->nullable();
            $table->string('higher_math', 5)->nullable();
            $table->string('business_ent', 5)->nullable();
            $table->string('accounting', 5)->nullable();
            $table->string('management', 5)->nullable();
            $table->string('finance_banking', 5)->nullable();
            $table->string('general_science', 5)->nullable();
            $table->string('civic_citizenship', 5)->nullable();
            $table->string('geography', 5)->nullable();
            $table->string('economics', 5)->nullable();
            $table->string('history', 5)->nullable();

            // HSC Info
            $table->string('hsc_roll', 30)->nullable();
            $table->year('hsc_year')->nullable();
            $table->string('hsc_reg', 30)->nullable();
            $table->string('hsc_session', 20)->nullable();
            $table->decimal('hsc_gpa', 4, 2)->nullable();
            $table->unsignedTinyInteger('hsc_total_a_plus')->nullable();
            $table->unsignedSmallInteger('hsc_total_appeared')->nullable();
            $table->unsignedSmallInteger('hsc_total_passed')->nullable();
            $table->decimal('hsc_percentage', 5, 2)->nullable();
            $table->string('hsc_tec', 100)->nullable();
            $table->string('hsc_subject', 100)->nullable();
            $table->string('hsc_total_combined', 100)->nullable();
            $table->string('hsc_subject_4th', 50)->nullable();
            $table->string('hsc_grade_4th_sub', 5)->nullable();

            // HSC Subjects
            $table->string('hsc_bangla', 5)->nullable();
            $table->string('hsc_english', 5)->nullable();
            $table->string('hsc_ict', 5)->nullable();
            $table->string('hsc_physics', 5)->nullable();
            $table->string('hsc_chemistry', 5)->nullable();
            $table->string('hsc_biology', 5)->nullable();
            $table->string('hsc_higher_math', 5)->nullable();
            $table->string('hsc_businessEnt', 5)->nullable();
            $table->string('hsc_accounting', 5)->nullable();
            $table->string('hsc_management', 5)->nullable();
            $table->string('hsc_financeBanking', 5)->nullable();
            $table->string('hsc_generalScience', 5)->nullable();
            $table->string('hsc_civicCitizenship', 5)->nullable();
            $table->string('hsc_geography', 5)->nullable();
            $table->string('hsc_economics', 5)->nullable();
            $table->string('hsc_history', 5)->nullable();

            // Parents
            $table->string('father_phone_no', 25)->nullable();
            $table->string('father_occupation', 100)->nullable();
            $table->string('father_designation', 100)->nullable();
            $table->string('father_office_address', 255)->nullable();
            $table->string('father_nid', 100)->nullable();

            $table->string('mother_phone_no', 25)->nullable();
            $table->string('mother_occupation', 100)->nullable();
            $table->string('mother_designation', 100)->nullable();
            $table->string('mother_office_address', 255)->nullable();
            $table->string('mother_nid', 100)->nullable();

            $table->unsignedInteger('monthly_income_parents')->nullable();
            $table->unsignedInteger('monthly_income_family')->nullable();

            // Guardian Info
            $table->string('local_guardian_relation', 50)->nullable();
            $table->string('local_guardian_name', 100)->nullable();
            $table->string('local_guardian_occupation', 100)->nullable();
            $table->string('local_guardian_designation', 100)->nullable();
            $table->string('local_guardian_phone_res', 25)->nullable();
            $table->string('local_guardian_phone_office', 25)->nullable();
            $table->string('local_guardian_nid', 100)->nullable();
            $table->string('local_guardian_organization', 150)->nullable();
            $table->string('local_guardian_address', 255)->nullable();

            // Contact & Address
            $table->string('present_address', 255)->nullable();
            $table->string('present_address_phone', 25)->nullable();
            $table->string('permanent_address', 255)->nullable();
            $table->string('permanent_district', 100)->nullable();

            // Co-Curricular Activities (longer text)
            $table->text('co_curricular_activities_sports')->nullable();
            $table->text('co_curricular_activities_clubs')->nullable();
            $table->text('co_curricular_activities_others')->nullable();
            $table->text('vital_sports')->nullable();
            $table->text('vital_sports_college_team')->nullable();
            $table->text('vital_sports_inter_class')->nullable();
            $table->text('vital_sports_awards')->nullable();

            $table->text('science_club')->nullable();
            $table->text('science_club_awards')->nullable();
            $table->text('science_fair')->nullable();
            $table->text('science_fair_awards')->nullable();
            $table->text('com_arts_sci_club')->nullable();
            $table->text('com_arts_sci_awards')->nullable();
            $table->text('notre_dame_volunteers_alliance')->nullable();
            $table->text('notre_dame_volunteers_alliance_awards')->nullable();
            $table->text('debate_collage')->nullable();
            $table->text('inter_collage')->nullable();
            $table->text('inter_collage_awards')->nullable();

            // Scholarships
            $table->string('scholarship_type', 50)->nullable();
            $table->unsignedInteger('annual_lump_grant_1st_year_tk')->nullable();
            $table->unsignedInteger('annual_lump_grant_2nd_year_tk')->nullable();
            $table->unsignedInteger('monthly_tk')->nullable();
            $table->unsignedTinyInteger('period_total_months')->nullable();
            $table->year('from_year')->nullable();
            $table->year('to_year')->nullable();

            // Misc Academic
            $table->date('dropped_date')->nullable();
            $table->string('recommendation_gives_on', 100)->nullable();
            $table->string('reason', 150)->nullable();
            $table->string('promoted_to_class_xll', 50)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('students');
    }
};
