<?php

namespace App\Library;

use Twilio\Rest\Client;

class SMSGateway
{
    public static function send($receiver, $otp): string
    {
        $config = self::getSettings('twilio');
        if (isset($config) && $config['status'] == 1) {
            return self::twilio($receiver, $otp);
        }

        $config = self::getSettings('nexmo');
        if (isset($config) && $config['status'] == 1) {
            return self::nexmo($receiver, $otp);
        }

        $config = self::getSettings('2factor');
        if (isset($config) && $config['status'] == 1) {
            return self::twoFactor($receiver, $otp);
        }

        $config = self::getSettings('msg91');
        if (isset($config) && $config['status'] == 1) {
            return self::msg91($receiver, $otp);
        }

        $config = self::getSettings('releans');
        if (isset($config) && $config['status'] == 1) {
            return self::releans($receiver, $otp);
        }

        return 'not_found';
    }

    public static function twilio($receiver, $otp): string
    {
        $config = self::getSettings('twilio');
        $response = 'error';
        if (isset($config) && $config['status'] == 1) {
            $message = str_replace('#OTP#', $otp, $config['otp_template']);
            $sid = $config['sid'];
            $token = $config['token'];
            try {
                $twilio = new Client($sid, $token);
                $twilio->messages
                    ->create(
                        $receiver, // to
                        [
                            'messagingServiceSid' => $config['messaging_service_sid'],
                            'body' => $message,
                        ]
                    );
                $response = 'success';
            } catch (\Exception $exception) {
                $response = 'error';
            }
        }

        return $response;
    }

    public static function nexmo($receiver, $otp): string
    {
        $sms_nexmo = self::getSettings('nexmo');
        $response = 'error';
        if (isset($sms_nexmo) && $sms_nexmo['status'] == 1) {
            try {
                $ch = curl_init();

                curl_setopt($ch, CURLOPT_URL, 'https://rest.nexmo.com/sms/json');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, 'from='.$sms_nexmo['from'].'&text='.$sms_nexmo['otp_template'].'&to='.$receiver.'&api_key='.$sms_nexmo['api_key'].'&api_secret='.$sms_nexmo['api_secret']);

                $headers = [];
                $headers[] = 'Content-Type: application/x-www-form-urlencoded';
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo 'Error:'.curl_error($ch);
                }
                curl_close($ch);
                $response = 'success';
            } catch (\Exception $exception) {
                $response = 'error';
            }
        }

        return $response;
    }

    public static function twoFactor($receiver, $otp): string
    {
        $config = self::getSettings('2factor');
        $response = 'error';
        if (isset($config) && $config['status'] == 1) {
            $api_key = $config['api_key'];
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => 'https://2factor.in/API/V1/'.$api_key.'/SMS/'.$receiver.'/'.$otp.'',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            ]);
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);

            if (! $err) {
                $response = 'success';
            } else {
                $response = 'error';
            }
        }

        return $response;
    }

    public static function msg91($receiver, $otp): string
    {
        $sms_nexmo = self::getSettings('nexmo');
        $response = 'error';
        if (isset($sms_nexmo) && $sms_nexmo['status'] == 1) {
            try {
                $receiver = str_replace('+', '', $receiver);
                $value = 'from='.$sms_nexmo['from']
                    .'&text='.$sms_nexmo['otp_template'].' '.$otp.'&type=unicode'
                    .'&to='.$receiver
                    .'&api_key='.$sms_nexmo['api_key']
                    .'&api_secret='.$sms_nexmo['api_secret'];
                $ch = curl_init();

                curl_setopt($ch, CURLOPT_URL, 'https://rest.nexmo.com/sms/json');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $value);

                $headers = [];
                $headers[] = 'Content-Type: application/x-www-form-urlencoded';
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo 'Error:'.curl_error($ch);
                }
                curl_close($ch);
                $response = 'success';
            } catch (\Exception $exception) {
                $response = 'error';
            }
        }

        return $response;
    }

    public static function releans($receiver, $otp): string
    {
        $config = self::getSettings('releans');
        $response = 'error';
        if (isset($config) && $config['status'] == 1) {
            $curl = curl_init();
            $from = $config['from'];
            $to = $receiver;
            $message = str_replace('#OTP#', $otp, $config['otp_template']);

            try {
                curl_setopt_array($curl, [
                    CURLOPT_URL => 'https://api.releans.com/v2/message',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => "sender=$from&mobile=$to&content=$message",
                    CURLOPT_HTTPHEADER => [
                        'Authorization: Bearer '.$config['api_key'],
                    ],
                ]);
                $response = curl_exec($curl);
                curl_close($curl);
                $response = 'success';
            } catch (\Exception $exception) {
                $response = 'error';
            }
        }

        return $response;
    }

    public static function getSettings($name)
    {
        $data = businessConfig($name, SMS_CONFIG);
        if (isset($data)) {
            return $data['value'];
        }

        return null;
    }
}
