import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/side_menu/src/side_bar_controller.dart';
import 'package:mighty_school/util/styles.dart';

class SideMenuChildItemWidget extends StatelessWidget {
  final String title;
  final String keyValue;
  final VoidCallback onTap;
  final String? icon;

  const SideMenuChildItemWidget({super.key, required this.title, required this.keyValue, required this.onTap, this.icon});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SidebarController>(builder: (controller) {
      final bool selected = controller.isActive(keyValue);


      return InkWell(onTap: () {
          controller.onNestedTap(keyValue);
          onTap();
        },
        child: Padding(
          padding: const EdgeInsets.symmetric(vertical: 8.0),
          child: Row(children: [
              Icon(Icons.arrow_right_alt, color: selected ? Theme.of(context).primaryColor : Theme.of(context).dividerColor,),
              Expanded(child: Text(title,
                style: textRegular.copyWith(color: selected ? Theme.of(context).primaryColor : Theme.of(context).textTheme.displayLarge?.color,
                    fontWeight: selected ? FontWeight.bold : FontWeight.normal)),
              ),
            ],
          ),
        ),
      );
    });
  }
}
