
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/layout/list_layout_widget.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_snackbar.dart';
import 'package:mighty_school/feature/fees_management/fees_date/controller/fees_date_controller.dart';
import 'package:mighty_school/feature/fees_management/fees_date/domain/model/fees_date_model.dart';
import 'package:mighty_school/feature/fees_management/fees_date/presentation/widgets/fees_date_card_widget.dart';
import 'package:mighty_school/feature/fees_management/fees_head/controller/fees_head_controller.dart';
import 'package:mighty_school/feature/fees_management/fees_head/presentation/widgets/select_fees_head_widget.dart';
import 'package:mighty_school/util/dimensions.dart';

class FeeDateConfigListWidget extends StatelessWidget {
  final ScrollController scrollController;
  const FeeDateConfigListWidget({super.key, required this.scrollController});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<FeesDateController>(
      initState: (_) => Get.find<FeesDateController>().getFeesDateList(1),
      builder: (controller) {
        FeesDateModel? model = controller.feesDateModel;
        final data = model?.data;

        return GenericListSection<FeesDateItem>(
          addNewTitle: "new_date_config".tr,
          onAddNewTap: (){

          },
          sectionTitle: "fees_management".tr,
          pathItems: ["fee_date_config".tr],
          topWidget: Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault),
            child: Row(crossAxisAlignment: CrossAxisAlignment.end, spacing: Dimensions.paddingSizeSmall,  children: [
              const Expanded(child: SelectFeesHeadWidget()),
              Padding(padding: const EdgeInsets.only(bottom: 9),
                  child: SizedBox(width: 90, child: CustomButton(onTap: (){
                    int? feeHeadId = Get.find<FeesHeadController>().selectedFeesHeadItem?.id;

                    if(feeHeadId == null){
                      showCustomSnackBar("select_fee_head".tr);
                    }else {
                      controller.getFeesDateList(1, feeHeadId: feeHeadId.toString());
                    }
                  }, text: "search".tr)))
            ],),
          ),
          headings: const ["name", "fee_payable_date", "fee_activation_date"],
          scrollController: scrollController,
          isLoading: model == null,
          totalSize: data?.total ?? 0,
          offset: data?.currentPage ?? 0,
          onPaginate: (offset) => controller.getFeesDateList(offset ?? 1),
          items: data?.data ?? [],
          itemBuilder: (item, index) => FeesDateCardWidget(index: index, feesDateItem: item),
          showAction: false,
        );
      },
    );
  }
}
