
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/html_viewer.dart';
import 'package:mighty_school/feature/landing_page/frontend_course/domain/model/my_course_details_model.dart';
import 'package:mighty_school/feature/landing_page/frontend_course/logic/frontend_course_controller.dart';
import 'package:mighty_school/feature/landing_page/frontend_course/presentation/widgets/frontend_course_summery_overview_widget.dart';
import 'package:mighty_school/feature/landing_page/frontend_course/presentation/widgets/preview_content_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class CourseDetailsInformationDetailsWidget extends StatefulWidget {
  final MyCourseDetailsModel courseDetailsModel;
  const CourseDetailsInformationDetailsWidget({super.key, required this.courseDetailsModel});

  @override
  State<CourseDetailsInformationDetailsWidget> createState() => _CourseDetailsInformationDetailsWidgetState();
}

class _CourseDetailsInformationDetailsWidgetState extends State<CourseDetailsInformationDetailsWidget> {
  final ScrollController _scrollController = ScrollController();
  double _summaryTop = 0;
  final GlobalKey _footerKey = GlobalKey();

  @override
  void initState() {
    super.initState();
    _scrollController.addListener(_handleScroll);
  }

  void _handleScroll() {
    final RenderBox? footerBox =
    _footerKey.currentContext?.findRenderObject() as RenderBox?;
    final double footerY = footerBox?.localToGlobal(Offset.zero).dy ?? double.infinity;

    const double summaryHeight = 660;
    if (footerY < summaryHeight + 100) {
      double offset = summaryHeight + 100 - footerY;
      setState(() {
        _summaryTop = 0 - offset;
      });
    } else {
      setState(() {
        _summaryTop = 0;
      });
    }
  }

  @override
  void dispose() {
    _scrollController.dispose();
    super.dispose();
  }


  @override
  Widget build(BuildContext context) {
    Courses? course = widget.courseDetailsModel.data;
    final bool isDesktop = ResponsiveHelper.isDesktop(context);
    return GetBuilder<FrontendCourseController>(builder: (courseController) {
      return Stack(children: [
          SingleChildScrollView(controller: _scrollController,
            child: Column(children: [
              Center(child: Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault),
                child: SizedBox(width: Dimensions.webMaxWidth,
                  child: Row(crossAxisAlignment: CrossAxisAlignment.start, children: [

                    SizedBox(width: isDesktop?
                    Dimensions.webMaxWidth - 400 : Get.width-30,
                      child: Column(spacing: Dimensions.paddingSizeDefault, crossAxisAlignment: CrossAxisAlignment.start, children: [
                        Text(course?.courseTitle ?? '',
                            style: textBold.copyWith(fontSize: Dimensions.fontSizeOverLarge)),

                        HtmlViewer(htmlText: course?.courseDescription??''),
                        PreviewCourseContentWidget(courseDetailsModel: widget.courseDetailsModel),

                      ])),

                    if(isDesktop)...[
                      const SizedBox(width: 20),
                      const SizedBox(width: 350)],

                  ])),
              )),
            ])),

          if(isDesktop)
          Positioned(top: _summaryTop,
            left: MediaQuery.of(context).size.width / 2 + (Dimensions.webMaxWidth / 2 - 350),
            child: SizedBox(width: 350, child: FrontendCourseSummeryOverviewWidget(courseDetailsModel: widget.courseDetailsModel))),
        ],
      );
    });
  }
}