
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/video_section/universal_video_player.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_divider.dart';
import 'package:mighty_school/feature/landing_page/frontend_course/domain/model/my_course_details_model.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/app_constants.dart';
import 'package:mighty_school/util/dimensions.dart';

class FrontendCourseSummeryOverviewWidget extends StatelessWidget {
  final MyCourseDetailsModel courseDetailsModel;
  const FrontendCourseSummeryOverviewWidget({super.key, required this.courseDetailsModel});

  @override
  Widget build(BuildContext context) {
    return CustomContainer(horizontalPadding: 0,verticalPadding: 0, width: ResponsiveHelper.isDesktop(context)?350: Get.width-30,
        child: Column(mainAxisSize: MainAxisSize.min, children: [
          (courseDetailsModel.data?.courseVideoType == "upload")?
          UniversalVideoPlayer(videoUrl: "${AppConstants.baseUrl}/storage/lessons/${courseDetailsModel.data?.courseUploadedVideoPath ?? ""}"):
          UniversalVideoPlayer(videoUrl: "${courseDetailsModel.data?.courseVideoUrl}"),
          const CustomDivider(),

          Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
            child: Column(spacing: Dimensions.paddingSizeDefault, children: [
          // FrontendCourseSummeryInfoWidget(icon: Images.student, title: "student_joined".tr, count: "${courseDetailsModel.data?.courseFakeEnrolledStudents??0}",),
          // FrontendCourseSummeryInfoWidget(icon: Images.video, title: "video_classes".tr, count: "${courseDetailsModel.data?.courseTotalClasses??0}",),
          // FrontendCourseSummeryInfoWidget(icon: Images.notes, title: "total_notes".tr, count: "${courseDetailsModel.data?.courseTotalNotes??0}"),
          // FrontendCourseSummeryInfoWidget(icon: Images.quiz, title: "total_exams".tr, count: "${courseDetailsModel.data?.courseTotalExams??0}",),
          //

              // Text(PriceConverter.convertPrice(context, courseDetailsModel.data?.courseOfferPrice??0),
              //     style: Theme.of(context).textTheme.headlineMedium),

              CustomButton(buttonColor: Theme.of(context).cardColor,
                showBorderOnly: true,
                borderWidth: .25,

                borderColor: Theme.of(context).primaryColor,
                textColor: Theme.of(context).primaryColor,
                onTap: () async {}, text: "add_to_cart".tr,),

              CustomButton(onTap: () async {}, text: "buy_now".tr)]))

        ]));
  }
}
