import 'package:carousel_slider/carousel_slider.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/feature/landing_page/domain/models/banner_model.dart';
import 'package:mighty_school/feature/landing_page/logic/landing_page_controller.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/banner_shimmer_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/app_constants.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/images.dart';
import 'package:mighty_school/util/styles.dart';



class BannerWidget extends StatelessWidget {
  const BannerWidget({super.key});

  @override
  Widget build(BuildContext context) {
    final isDesktop = ResponsiveHelper.isDesktop(context);
    final isTablet = ResponsiveHelper.isTablet(context);
    final screenWidth = MediaQuery.of(context).size.width;
    final bannerHeight = isDesktop ? screenWidth * 0.45 :
    isTablet ? screenWidth * 0.6 : screenWidth * 0.56;

    return GetBuilder<LandingPageController>(
      initState: (val) {
        if (Get.find<LandingPageController>().bannerModel == null) {
          Get.find<LandingPageController>().getBannerData();
        }
      },
      builder: (landingPageController) {
        BannerModel? bannerModel = landingPageController.bannerModel;
        return SizedBox(height: bannerHeight, width: screenWidth,
          child: (bannerModel != null && bannerModel.data?.isNotEmpty == true)?
        CarouselSlider.builder(itemCount: bannerModel.data?.length,
          itemBuilder: (BuildContext context, int itemIndex, int pageViewIndex) {
            final banner = bannerModel.data?[itemIndex];
            return Stack(alignment: Alignment.center, children: [

              ClipRRect(child: CustomImage(width: screenWidth, height: bannerHeight,
                  image: "${AppConstants.imageBaseUrl}/banners/${banner?.image}",
                  fit: BoxFit.cover, placeholder: Images.bannerPlaceHolder,)),

              Container(width: screenWidth, height: bannerHeight,
                  decoration: BoxDecoration(gradient: LinearGradient(
                      begin: Alignment.topCenter, end: Alignment.bottomCenter,
                      colors: [
                        Theme.of(context).primaryColorDark.withValues(alpha: 0.3),
                        Theme.of(context).primaryColorDark.withValues(alpha: 0.6),
                        Theme.of(context).primaryColorDark.withValues(alpha: 0.8),
                      ]))),

              Center(child: Padding(padding: const EdgeInsets.symmetric(horizontal: 20.0),
                  child: Column(mainAxisSize: MainAxisSize.min, children: [

                    SizedBox(width: 1000,
                      child: Text(banner?.title ?? "banner_title_placeholder".tr, textAlign: TextAlign.center,
                          style: textRegular.copyWith(
                              fontSize: isDesktop ? 46 : isTablet ? 32 : Dimensions.fontSizeExtraLarge,
                              color: Colors.white, fontWeight: FontWeight.bold)),
                    ),

                    const SizedBox(height: 10),

                    Text(banner?.description ?? "banner_description_placeholder".tr, textAlign: TextAlign.center,
                        style: textMedium.copyWith(
                            fontSize: isDesktop ? 20 : isTablet ? 16 : Dimensions.fontSizeDefault,
                            color: Colors.white, height: 1.4)),

                    const SizedBox(height: 25),

                    // Container(decoration: BoxDecoration(borderRadius: BorderRadius.circular(30),
                    //     boxShadow: [BoxShadow(color: Theme.of(context).primaryColor.withValues(alpha: 0.4),
                    //         blurRadius: 20, spreadRadius: 2)]),
                    //     child: SizedBox(width: isDesktop ? 180 : isTablet ? 160 : 140, height: 50,
                    //         child: CustomButton(onTap: () {}, text: "apply_now".tr, borderRadius: 30))),
                  ])),
              ),
            ]);
          },
          options: CarouselOptions(autoPlay: (bannerModel.data?.length ?? 0) > 2, viewportFraction: 1, initialPage: 0),
        ) : const BannerShimmerWidget(),
        );
      },
    );
  }
}

