import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/feature/landing_page/domain/models/testimonial_model.dart';
import 'package:mighty_school/feature/landing_page/logic/landing_page_controller.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/testimonial_section_loading_widget.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/images.dart';
import 'package:mighty_school/util/styles.dart';
import 'package:carousel_slider/carousel_slider.dart';


class TestimonialSection extends StatefulWidget {
  const TestimonialSection({super.key});

  @override
  State<TestimonialSection> createState() => TestimonialSectionState();
}

class TestimonialSectionState extends State<TestimonialSection> {
  double getViewportFraction(BuildContext context) {
    final width = MediaQuery.of(context).size.width;

    if (width >= 1200) {
      return 0.25;
    } else if (width >= 900) {
      return 0.33;
    } else if (width >= 600) {
      return 0.5;
    } else {
      return 0.9;
    }
  }

  List<List<TestimonialItem>> chunkList(List<TestimonialItem> list, int chunkSize) {
    List<List<TestimonialItem>> chunks = [];
    for (var i = 0; i < list.length; i += chunkSize) {
      chunks.add(
        list.sublist(i, i + chunkSize > list.length ? list.length : i + chunkSize),
      );
    }
    return chunks;
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<LandingPageController>(
      initState: (val) {
        final landingPageController = Get.find<LandingPageController>();
        if (landingPageController.testimonialModel == null) {
          landingPageController.getTestimonialData();
        }
      },
      builder: (landingPageController) {
        TestimonialModel? testimonialModel = landingPageController.testimonialModel;

        if (testimonialModel == null) {
          return const TestimonialSectionLoadingWidget();
        }

        final data = testimonialModel.data ?? [];
        final chunkedData = chunkList(data, 2);

        return Container(width: double.infinity,
          padding: const EdgeInsets.symmetric(vertical: Dimensions.paddingSizeOver),
          child: Center(
            child: SizedBox(width: Dimensions.webMaxWidth,
              child: CarouselSlider.builder(
                options: CarouselOptions(autoPlay: true,
                    enlargeCenterPage: false,
                    viewportFraction: getViewportFraction(context),
                    enableInfiniteScroll: true,
                    height: 300),
                itemCount: chunkedData.length,
                itemBuilder: (context, index, _) {
                  final group = chunkedData[index];
                  return Column(children: group.map((item) {
                    return Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeSmall),
                        child: TestimonialCard(item: item));
                  }).toList(),
                  );
                },
              ),
            ),
          ),
        );
      },
    );
  }
}

class TestimonialCard extends StatelessWidget {
  final TestimonialItem? item;
  const TestimonialCard({super.key, this.item});

  @override
  Widget build(BuildContext context) {
    return CustomContainer(borderRadius: Dimensions.paddingSizeExtraSmall,
      child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
        Row(children: [
          CustomImage(image: item?.user?.image, height: 50, width: 50, fit: BoxFit.cover, placeholder: Images.profilePlaceHolder),
          const SizedBox(width: Dimensions.paddingSizeSmall),
          Expanded(child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
            Text(item?.user?.name ?? '', style: textBold.copyWith(fontSize: Dimensions.fontSizeLarge)),
            Text(item?.user?.email ?? 'Nursery', style: textRegular.copyWith(color: Theme.of(context).hintColor)),
          ]))]),
        const SizedBox(height: Dimensions.paddingSizeSmall),
        Text(item?.description ?? 'N/A', maxLines: 4, overflow: TextOverflow.ellipsis,
            style: textRegular.copyWith(height: 1.5, color: Theme.of(context).hintColor)),
      ],
      ),
    );
  }
}
