import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_app_bar.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/feature/authentication/logic/authentication_controller.dart';
import 'package:mighty_school/feature/landing_page/logic/landing_page_controller.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/banner_widget.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/about_us.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/gallery_widget.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/why_chose_us_widget.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/admisssions_widget.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/teachers_widget.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/testimonial_section.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/stay_connected_widget.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/event_widget.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/faq_widget.dart';
import 'package:mighty_school/feature/landing_page/presentation/widgets/logo_section_widget.dart';
import 'package:mighty_school/feature/profile/presentation/widgets/header_profile_info_dropdown.dart';
import 'package:mighty_school/helper/route_helper.dart';
import 'package:mighty_school/util/dimensions.dart';

class MobileLandingPage extends StatefulWidget {
  const MobileLandingPage({super.key});

  @override
  State<MobileLandingPage> createState() => _MobileLandingPageState();
}

class _MobileLandingPageState extends State<MobileLandingPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(appBar: CustomAppBar(
      titleWidget: const Row(children: [
          LogoSectionWidget(),
        ]), actions: [
      Padding(
        padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault),
        child: GetBuilder<AuthenticationController>(
            builder: (authenticationController) {
              return authenticationController.isLoggedIn()?
              const HeaderProfileInfoMenu():
              IntrinsicWidth(child: CustomButton(height: 35, onTap: (){
                Get.toNamed(RouteHelper.getSignInRoute());
              }, text: "login".tr));
            }
        ),
      ),
    ],
    ),
    body: CustomScrollView(slivers: [
      SliverToBoxAdapter(child: GetBuilder<LandingPageController>(builder: (landingPageController) {
          return Column(children: [
            buildSection(landingPageController.sectionKeys[0], const BannerWidget()),
            buildSection(landingPageController.sectionKeys[1], const AboutUsWidget()),
            buildSection(landingPageController.sectionKeys[2], const WhyChooseUsWidget()),
            // buildSection(landingPageController.sectionKeys[3], const FrontendCourseWidget()),
            buildSection(landingPageController.sectionKeys[3], const AdmissionsWidget()),
            buildSection(landingPageController.sectionKeys[4], const TeachersWidget()),
            buildSection(landingPageController.sectionKeys[5], const GalleryWidget()),
            buildSection(landingPageController.sectionKeys[6], const TestimonialSection()),
            buildSection(landingPageController.sectionKeys[7], const StayConnectedWidget()),
            buildSection(landingPageController.sectionKeys[8], const EventWidget()),
            buildSection(landingPageController.sectionKeys[9], const FaqWidget()),
          ]);
        }
      ))
    ]));

  }
  Widget buildSection(GlobalKey key, Widget child) {
    return Container(key: key, child: child);
  }
}
