import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_text_field.dart';
import 'package:mighty_school/feature/library_management/book/controller/book_controller.dart';
import 'package:mighty_school/feature/library_management/book/domain/model/book_issue_model.dart';
import 'package:mighty_school/helper/date_converter.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/app_constants.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class BookReturnItemWidget extends StatelessWidget {
  final BookIssueItem? bookIssueItem;
  final int index;
  const BookReturnItemWidget({super.key, this.bookIssueItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return ResponsiveHelper.isDesktop(context)?
    Row(spacing: Dimensions.paddingSizeSmall, children: [
      SizedBox(width: 20, child: Checkbox(value: bookIssueItem?.isSelected??false, onChanged: (val){
        Get.find<BookController>().toggleBookIssues(index);
      }),),

      Expanded(child: Text(bookIssueItem?.code??'', style: textRegular,)),
      Expanded(child: Text(bookIssueItem?.libraryId??'', style: textRegular,)),
      Expanded(child: Text(bookIssueItem?.bookName??'', style: textRegular,)),
      Expanded(child: Text(DateConverter.quotationDate(DateTime.parse(bookIssueItem?.updatedAt??'${DateTime.now()}')), style: textRegular,)),
      Expanded(child: Text(bookIssueItem?.issueDate??'', style: textRegular,)),
      Expanded(child: CustomTextField(
        inputType: TextInputType.number,
        inputFormatters: [AppConstants.numberFormat],
          controller: bookIssueItem?.fineController, hintText: "0")),
      Expanded(child: CustomTextField(
          inputType: TextInputType.number,
          inputFormatters: [AppConstants.numberFormat],
          controller: bookIssueItem?.lostController, hintText: "0")),

      Text(bookIssueItem?.status??'', style: textRegular,),




    ],):
    Row(spacing: Dimensions.paddingSizeSmall, children: [
        SizedBox(width: 20, child: Checkbox(value: bookIssueItem?.isSelected??false, onChanged: (val){
          Get.find<BookController>().toggleBookIssues(index);
        }),),
        Expanded(
          child: Column(children: [
            Text(bookIssueItem?.code??'', style: textRegular,),
            Text(bookIssueItem?.libraryId??'', style: textRegular,),
            Text(bookIssueItem?.bookName??'', style: textRegular,),
            Text(bookIssueItem?.issueDate??'', style: textRegular,),
            Text(bookIssueItem?.returnDate??'', style: textRegular,),
            CustomTextField(
                inputType: TextInputType.number,
                inputFormatters: [AppConstants.numberFormat],
                controller: bookIssueItem?.fineController, hintText: "0"),
            CustomTextField(
                inputType: TextInputType.number,
                inputFormatters: [AppConstants.numberFormat],
                controller: bookIssueItem?.lostController, hintText: "0"),
            Expanded(child: Text(bookIssueItem?.status??'', style: textRegular,)),




          ],),
        ),
      ],
    );
  }
}
