

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:html_editor_enhanced/html_editor.dart';
import 'package:mighty_school/common/coutom_royte_path/custom_route_path_widget.dart';
import 'package:mighty_school/common/widget/add_new_resource_widget.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_dropdown.dart';
import 'package:mighty_school/common/widget/custom_rich_text_editor_widget/custom_rich_editor.dart';
import 'package:mighty_school/common/widget/custom_snackbar.dart';
import 'package:mighty_school/common/widget/custom_text_field.dart';
import 'package:mighty_school/common/widget/custom_title.dart';
import 'package:mighty_school/feature/question_bank/question/domain/model/question_body.dart';
import 'package:mighty_school/feature/question_bank/question/domain/model/question_model.dart';
import 'package:mighty_school/feature/question_bank/question/logic/question_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_board/logic/question_bank_board_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_board/presentation/widgets/select_question_bank_board_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_chapter/logic/question_bank_chapter_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_chapter/presentation/widgets/select_question_bank_chapter_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_class/logic/question_bank_class_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_class/presentation/widgets/select_question_bank_class_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_group/logic/question_bank_group_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_group/presentation/widgets/select_question_bank_group_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_level/logic/question_bank_level_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_level/presentation/widgets/select_question_bank_level_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_sources/logic/question_bank_sources_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_sources/presentation/widgets/select_question_bank_source_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_sub_sources/logic/question_bank_sub_sources_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_sub_sources/presentation/widgets/select_question_bank_sub_source_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_subject/logic/question_bank_subject_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_subject/presentation/widgets/select_question_bank_subject_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_tag/presentation/widgets/select_question_bank_year_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_topics/logic/question_bank_topics_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_topics/presentation/widgets/select_question_bank_topic_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_types/logic/question_bank_types_controller.dart';
import 'package:mighty_school/feature/question_bank/question_bank_types/presentation/widgets/select_question_bank_types_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_year/logic/question_bank_year_controller.dart';
import 'package:mighty_school/feature/question_bank/question_category/logic/question_category_controller.dart';
import 'package:mighty_school/feature/question_bank/question_category/presentation/widgets/select_question_category_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/helper/route_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/images.dart';
import 'package:mighty_school/util/styles.dart';
import 'package:responsive_grid/responsive_grid.dart';



class CreateNewQuestionWidget extends StatefulWidget {
  final QuestionItem? questionItem;
  final VoidCallback? onEditorPointerDown;
  final VoidCallback? onEditorPointerUp;
  const CreateNewQuestionWidget({super.key, this.questionItem, this.onEditorPointerDown, this.onEditorPointerUp});

  @override
  State<CreateNewQuestionWidget> createState() => _CreateNewQuestionWidgetState();
}

class _CreateNewQuestionWidgetState extends State<CreateNewQuestionWidget> {
  TextEditingController nameController = TextEditingController();
   HtmlEditorController questionTextController = HtmlEditorController();
   HtmlEditorController explanationController = HtmlEditorController();


  @override
  void initState() {
    Get.find<QuestionController>().clearQuestionYearBody();
    Get.find<QuestionController>().clearAllOption();
    super.initState();
    if (widget.questionItem != null) {
      nameController.text = widget.questionItem?.questionName ?? "";

      WidgetsBinding.instance.addPostFrameCallback((_) {
        Future.delayed(const Duration(milliseconds: 2000), () async {
          questionTextController.setText(widget.questionItem!.question??'');
          explanationController.setText(widget.questionItem?.explanation??'');

        });
      });

      Get.find<QuestionController>().changeQuestionType(widget.questionItem?.type, notify: false);
      if(widget.questionItem?.classItem != null) {
        Get.find<QuestionBankClassController>().setSelectClass(widget.questionItem!.classItem!, notify: false);
      }
      if(widget.questionItem?.group != null) {
        Get.find<QuestionBankGroupController>().setSelectGroupItem(widget.questionItem!.group!, notify: false);
      }
      if(widget.questionItem?.subject != null) {
        Get.find<QuestionBankSubjectController>().setSelectSubjectItem(widget.questionItem!.subject!, notify: false);
      }
      if(widget.questionItem?.chapter != null) {
        Get.find<QuestionBankChapterController>().setSelectChapterItem(widget.questionItem!.chapter!, notify: false);
      }

      if(widget.questionItem?.questionCategory != null) {
        Get.find<QuestionCategoryController>().setSelectQuestionCategoryItem(widget.questionItem!.questionCategory!, notify: false);
      }
      if(widget.questionItem?.levels != null && widget.questionItem!.levels!.isNotEmpty) {
        Get.find<QuestionBankLevelController>().setSelectLevelItem(widget.questionItem!.levels![0], notify: false);
      }

      if(widget.questionItem?.topics != null && widget.questionItem!.topics!.isNotEmpty) {
        Get.find<QuestionBankTopicsController>().setSelectQuestionBankTopicItem(widget.questionItem!.topics![0], notify: false);
      }

      if(widget.questionItem?.types != null && widget.questionItem!.types!.isNotEmpty) {
        Get.find<QuestionBankTypesController>().setSelectTypeItem(widget.questionItem!.types![0], notify: false);
      }
      if(widget.questionItem?.sources != null && widget.questionItem!.sources!.isNotEmpty) {
        Get.find<QuestionBankSourcesController>().setQuestionBankSourcesItem(widget.questionItem!.sources![0], notify: false);
      }
      if(widget.questionItem?.subSources != null && widget.questionItem!.subSources!.isNotEmpty) {
        Get.find<QuestionBankSubSourcesController>().setQuestionBankSubSourcesItem(widget.questionItem!.subSources![0], notify: false);
      }
      if (widget.questionItem?.questionYear != null && widget.questionItem!.questionYear!.isNotEmpty) {

        List<dynamic> rawList = widget.questionItem!.questionYear!;

        Map<String, List<Board>> grouped = {};

        for (var item in rawList) {
          String year = item.year ?? "";
          Board board = Board(board: item.board, desc: item.desc);
          grouped.putIfAbsent(year, () => []).add(board);
        }

        List<QuestionYearBody> questionYearBodies = grouped.entries.map((entry) => QuestionYearBody(year: entry.key, board: entry.value)).toList();
        Get.find<QuestionController>().updateQuestionYearBody(questionYearBodies);
      }

      if(widget.questionItem?.options != null && widget.questionItem!.options!.isNotEmpty) {
        Get.find<QuestionController>().updateOption(widget.questionItem!);
      }

    }
  }

  @override
  void dispose() {
    nameController.dispose();
    questionTextController.disable();
    explanationController.disable();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Listener(
      onPointerDown: (_) => widget.onEditorPointerDown?.call(),
      onPointerUp: (_) => widget.onEditorPointerUp?.call(),
      child: GetBuilder<QuestionController>(
          builder: (questionController) {
            return Column(children: [
                Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault),
                    child: CustomRoutePathWidget(titleOnTap: () => Get.toNamed(RouteHelper.getQuestionRoute("question")),
                        title: "question_bank".tr, subWidget: Row(children: [
                      PathItemWidget(title: "add_question".tr,color: Theme.of(context).primaryColor),
                    ]))),

                CustomContainer(showShadow: false, borderRadius: 5,
                  child: Column(mainAxisSize: MainAxisSize.min,spacing: Dimensions.paddingSizeSmall, crossAxisAlignment: CrossAxisAlignment.start, children: [

                    CustomTitle(title: "question_setting", leftPadding: 0, webTitle: ResponsiveHelper.isDesktop(context)),

                    ResponsiveGridList(
                      shrinkWrap: true,
                        physics: const NeverScrollableScrollPhysics(),
                        desiredItemWidth: 200,
                        minSpacing: Dimensions.paddingSizeDefault,
                        children: [
                          Column(crossAxisAlignment: CrossAxisAlignment.start,spacing: Dimensions.paddingSizeSmall,
                            children: [
                              const CustomTitle(title: "question_type"),
                              CustomDropdown(width: Get.width, title: "select".tr,
                                items: questionController.questionType,
                                selectedValue: questionController.selectedQuestionType,
                                onChanged: (val){
                                  questionController.changeQuestionType(val!);
                                },
                              ),
                            ],
                          ),
                          if(questionController.selectedQuestionType != null)...[
                            const QuestionBankSelectClassWidget(required: true),
                            const QuestionBankSelectGroupWidget(required: true),
                            const QuestionBankSelectSubjectWidget(required: true),
                            const QuestionBankSelectChapterWidget(),
                            const SelectQuestionCategoryWidget(),
                            const QuestionBankSelectLevelWidget(),
                            const QuestionBankSelectTopicWidget(),
                            const QuestionBankSelectTypeWidget(),
                            const QuestionBankSelectSourceWidget(),
                            const QuestionBankSelectSubSourceWidget(),
                            const QuestionBankSelectYearWidget(),

                          ],

                          // QuestionBankSelectBoardWidget(),
                        ]
                    ),

                    GetBuilder<QuestionBankBoardController>(
                      builder: (boardController) {
                        return ListView.builder(
                            itemCount: questionController.questionYearBodyList.length,
                            shrinkWrap: true,
                            physics: const NeverScrollableScrollPhysics(),
                            padding: EdgeInsets.zero,
                            itemBuilder: (_,index){
                              return Row(children: [
                                Text("${index + 1}. ${questionController.questionYearBodyList[index].year}"),
                                Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeSmall),
                                    child: Container(width: 1, height: 15, color: Theme.of(context).hintColor)),
                                SizedBox(height: 30,
                                  child: ListView.builder(
                                    padding: EdgeInsets.zero,
                                    shrinkWrap: true,
                                    itemCount: questionController.questionYearBodyList[index].board?.length??0,
                                    scrollDirection: Axis.horizontal,
                                    itemBuilder: (_, boardIndex){
                                      String data = questionController.questionYearBodyList[index].board![boardIndex].board??"";
                                      return Padding(padding: const EdgeInsets.all(3.0), child: Text("$data, ", style: textRegular));
                                    },

                                  ),
                                ),
                                SizedBox(width: 170, child: QuestionBankSelectBoardWidget(index: index)),
                                const SizedBox(width: Dimensions.paddingSizeSmall),
                                InkWell(onTap: ()=> questionController.removeQuestionYearBody(questionController.questionYearBodyList[index]),
                                    child: const Icon(Icons.delete_forever, color: Colors.red)),

                              ]);
                            });
                      }
                    ),

                    CustomTitle(title: "question_details", leftPadding: 0, webTitle: ResponsiveHelper.isDesktop(context)),

                    CustomTextField(title: "question_name".tr, isRequired: true,
                      minLines: 3,maxLines: 5, inputType: TextInputType.multiline,
                      inputAction: TextInputAction.newline,
                      controller: nameController,
                      hintText: "question_name".tr,),


                    CustomRichEditor(title: "question_text".tr,hintText: "question_text".tr, controller: questionTextController, required: true, height: 200,),


                  ListView.builder(
                    shrinkWrap: true,
                    padding: EdgeInsets.zero,
                    physics: const NeverScrollableScrollPhysics(),
                    itemCount: questionController.options.length,
                    itemBuilder: (context, index) {
                      return Padding(padding: const EdgeInsets.only(bottom: Dimensions.paddingSizeDefault),
                        child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
                            Row( children: [

                              Text.rich(TextSpan(children: [
                                TextSpan(text: 'Option ${index + 1}', style:  textRegular.copyWith(fontSize: Dimensions.fontSizeLarge)),
                                TextSpan(text: "*", style: textRegular.copyWith(color: Colors.red))
                              ]),),
                              Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeSmall),
                                child: Container(width: 1, height: 15, color: Theme.of(context).hintColor),
                              ),

                              (questionController.selectedQuestionType == "multiple_true_false")?
                              Row(spacing: Dimensions.paddingSizeLarge, children: [
                                InkWell(onTap: ()=> questionController.selectOption(index),
                                    child: Row(spacing: Dimensions.paddingSizeExtraSmall, children: [
                                      Icon(questionController.options[index].isSelected?
                                      Icons.radio_button_checked : Icons.radio_button_off, color: questionController.options[index].isSelected?
                                      Theme.of(context).secondaryHeaderColor : null),
                                      Text("select_as_true".tr, style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall,
                                          color: questionController.options[index].isSelected? Theme.of(context).secondaryHeaderColor : null))])),

                                InkWell(onTap: ()=> questionController.selectOption(index),
                                    child: Row(spacing: Dimensions.paddingSizeExtraSmall, children: [
                                      Icon(!questionController.options[index].isSelected?
                                      Icons.radio_button_checked :Icons.radio_button_off, color: !questionController.options[index].isSelected?
                                      Theme.of(context).secondaryHeaderColor : null),
                                      Text("select_as_false".tr, style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall,
                                          color: !questionController.options[index].isSelected? Theme.of(context).secondaryHeaderColor : null))])),
                              ]): Row(children: [
                                Checkbox(value: questionController.options[index].isSelected,
                                    onChanged: (_) => questionController.selectOption(index)),
                                Text("select_as_a_answer".tr, style: textRegular.copyWith(color: questionController.options[index].isSelected?
                                Theme.of(context).secondaryHeaderColor :
                                Theme.of(context).textTheme.displaySmall?.color)),
                              ],),

                                const Spacer(),
                                if(index !=0)
                                CustomContainer(showShadow: false, border: Border.all(color: Colors.red, ),borderRadius: 5, verticalPadding: 5,
                                    child: Row(spacing: Dimensions.paddingSizeExtraSmall ,
                                  children: [
                                    SizedBox(height: 20, child: Image.asset(Images.deleteIcon, color: Colors.red)),
                                    Text("delete".tr, style: textSemiBold.copyWith(color: Colors.red)),

                                  ],
                                ),
                                  onTap: () => questionController.deleteOption(index)),
                              ]),
                            CustomTextField(minLines: 3, maxLines: 4,inputType: TextInputType.multiline,
                              inputAction: TextInputAction.newline,
                              controller: questionController.options[index].controller,
                              hintText: "enter_option".tr,
                            )]));
                    }),

                    AddNewResourceWidget(width: 160, title: "add_more_options".tr,onTap: ()=> questionController.addOption()),


                    CustomRichEditor(title: "explanation".tr, controller: explanationController, height: 250),


                    questionController.isLoading? const Padding(padding: EdgeInsets.all(Dimensions.paddingSizeDefault),
                        child: Center(child: CircularProgressIndicator())):

                    Padding(padding: const EdgeInsets.symmetric(vertical: Dimensions.paddingSizeDefault),
                        child: SizedBox(width: 200,
                          child: CustomButton(onTap: () async {
                            String name = nameController.text.trim();

                            String? questionText = await questionTextController.getText();
                            String explanation = await explanationController.getText();
                            int? selectedClassId = Get.find<QuestionBankClassController>().selectedClassItem?.id;
                            int? selectedGroupId = Get.find<QuestionBankGroupController>().selectedGroupItem?.id;
                            int? selectedSubjectId = Get.find<QuestionBankSubjectController>().selectSubjectItem?.id;
                            int? selectedChapterId = Get.find<QuestionBankChapterController>().selectChapterItem?.id;
                            int? selectedCategoryId = Get.find<QuestionCategoryController>().selectedQuestionCategoryItem?.id;
                            int? selectedTopicId = Get.find<QuestionBankTopicsController>().selectQuestionBankTopicItem?.id;
                            int? selectedTypeId = Get.find<QuestionBankTypesController>().selectTypeItem?.id;
                            int? selectedLevelId = Get.find<QuestionBankLevelController>().selectedLevelItem?.id;
                            int? selectedSourceId = Get.find<QuestionBankSourcesController>().selectedQuestionBankSourcesItem?.id;
                            int? selectedSubSourceId = Get.find<QuestionBankSubSourcesController>().selectedQuestionBankSubSourcesItem?.id;
                            int? selectedYearId = Get.find<QuestionBankYearController>().selectYearItem?.id;
                            List<QuestionYearBody>? questionYearBody = questionController.questionYearBodyList;
                            List<String> options = questionController.options.map((e) => e.controller.text.trim()).toList();
                            List<bool> isSelected = questionController.options.map((e) => e.isSelected).toList();

                            List<String> selectedOptions = [];
                            if(questionController.selectedQuestionType == "multiple_choice"){
                              for(int i = 0; i < options.length; i++) {
                                if (isSelected[i]) {
                                  selectedOptions.add(options[i]);
                                }
                              }
                            }else if(questionController.selectedQuestionType == "multiple_true_false"){
                              for(int i = 0; i < options.length; i++) {
                                if (isSelected[i]) {
                                  selectedOptions.add("true");
                                }else{
                                  selectedOptions.add("false");
                                }
                              }

                            }



                            QuestionBody questionBody = QuestionBody(
                              questionBankClassId: selectedClassId,
                              questionBankGroupId: selectedGroupId,
                              questionBankSubjectId: selectedSubjectId,
                              questionBankChapterId: selectedChapterId,
                              questionCategoryId: selectedCategoryId,
                              question: questionText,
                              questionName: name,
                              type: "${questionController.selectedQuestionType}",
                              explanation: explanation,
                              options: options,
                              correctAnswer: selectedOptions,
                              questionYear: questionYearBody,
                              types: selectedTypeId != null? [selectedTypeId] : [],
                              levels: selectedLevelId != null? [selectedLevelId] : [],
                              topics: selectedTopicId != null? [selectedTopicId] : [],
                              sources: selectedSourceId != null? [selectedSourceId] : [],
                              subSources: selectedSubSourceId != null? [selectedSubSourceId] : [],
                              session: selectedYearId != null? [selectedYearId] : [],
                              sMethod: widget.questionItem != null? "PUT" : "POST",

                            );

                            if(name.isEmpty){
                              showCustomSnackBar("name_is_empty".tr);
                            }
                            else if(questionText.isEmpty){
                              showCustomSnackBar("question_text_is_empty".tr);
                            }
                            else if(selectedClassId == null) {
                              showCustomSnackBar("select_class".tr);
                            }
                            else if(selectedGroupId == null) {
                              showCustomSnackBar("select_group".tr);
                            }
                            else if(selectedSubjectId == null) {
                              showCustomSnackBar("select_subject".tr);
                            }
                            else{
                              if(widget.questionItem != null){
                                questionController.editQuestion(questionBody, widget.questionItem!.id!);
                              }else{
                                questionController.createQuestion(questionBody).then((val){
                                  if(val.statusCode == 200){
                                    nameController.clear();
                                    questionTextController.clear();
                                    explanationController.clear();
                                  }
                                });
                              }

                            }
                          }, text: widget.questionItem != null? "update".tr : "save_and_continue".tr),
                        ))
                  ],),
                ),
              ],
            );
          }
      ),
    );
  }
}
