import 'package:mighty_school/helper/price_converter.dart';

class UnPaidSummeryModel {
  bool? status;
  String? message;
  List<UnpaidSummery>? data;

  UnPaidSummeryModel({this.status, this.message, this.data});

  UnPaidSummeryModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    message = json['message'];
    if (json['data'] != null) {
      data = <UnpaidSummery>[];
      json['data'].forEach((v) {
        data!.add(UnpaidSummery.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['status'] = status;
    data['message'] = message;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class UnpaidSummery {
  String? studentId;
  String? firstName;
  String? roll;
  double? totalFeeDue;
  double? totalSlipDue;
  double? totalDue;

  UnpaidSummery(
      {this.studentId,
        this.firstName,
        this.roll,
        this.totalFeeDue,
        this.totalSlipDue,
        this.totalDue});

  UnpaidSummery.fromJson(Map<String, dynamic> json) {
    studentId = json['student_id'].toString();
    firstName = json['first_name'];
    roll = json['roll'].toString();
    totalFeeDue = PriceConverter.parseAmount(json['total_fee_due']);
    totalSlipDue = PriceConverter.parseAmount(json['total_slip_due']);
    totalDue = PriceConverter.parseAmount(json['total_due']);
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['student_id'] = studentId;
    data['first_name'] = firstName;
    data['roll'] = roll;
    data['total_fee_due'] = totalFeeDue;
    data['total_slip_due'] = totalSlipDue;
    data['total_due'] = totalDue;
    return data;
  }
}
