import 'package:mighty_school/helper/price_converter.dart';

class DesignationModel {
  bool? status;
  String? message;
  Data? data;

  DesignationModel({this.status, this.message, this.data,});

  DesignationModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    message = json['message'];
    data = json['data'] != null ? Data.fromJson(json['data']) : null;

  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['status'] = status;
    data['message'] = message;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class Data {
  int? currentPage;
  List<DesignationItem>? data;
  int? total;

  Data(
      {this.currentPage,
        this.data,
        this.total});

  Data.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    if (json['data'] != null) {
      data = <DesignationItem>[];
      json['data'].forEach((v) {
        data!.add(DesignationItem.fromJson(v));
      });
    }
    total = json['total'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['current_page'] = currentPage;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    data['total'] = total;
    return data;
  }
}

class DesignationItem {
  int? id;
  int? instituteId;
  String? name;
  int? status;

  DesignationItem({this.id, this.instituteId, this.name, this.status});

  DesignationItem.fromJson(Map<String, dynamic> json) {
    id = PriceConverter.parseInt(json['id']);
    instituteId = PriceConverter.parseInt(json['institute_id']);
    name = json['name'];
    status = PriceConverter.parseInt(json['status']);
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['institute_id'] = instituteId;
    data['name'] = name;
    data['status'] = status;
    return data;
  }
}


