import 'package:get/get_connect/http/src/response/response.dart';
import 'package:mighty_school/api_handle/api_client.dart';
import 'package:mighty_school/util/app_constants.dart';

class DesignationRepository{
  final ApiClient apiClient;
  DesignationRepository({required this.apiClient});


  Future<Response?> getDesignationList(int page) async {
    return await apiClient.getData("${AppConstants.branches}?page=$page&perPage=10");
  }

  Future<Response?> createNewDesignation( String name) async {
    Map<String, String> fields = <String, String> {
      'name': name,
    };

    return await apiClient.postData(AppConstants.branches, fields);
  }

  Future<Response?> updateDesignation( String name, int id) async {
    Map<String, String> fields = <String, String> {
      'name': name,
      '_method' : "PUT"
    };
    return await apiClient.putData("${AppConstants.branches}/$id", fields);
  }
  

  Future<Response?> deleteDesignation (int id) async {
    return await apiClient.deleteData("${AppConstants.branches}/$id");
  }


}