import 'package:flutter/material.dart';
import 'package:mighty_school/feature/staff_information/designation/domain/models/designation_model.dart';
import 'package:mighty_school/feature/staff_information/designation/presentation/widgets/create_new_designation_widget.dart';
import 'package:mighty_school/util/dimensions.dart';

class CreateNewDesignationScreen extends StatefulWidget {
  final DesignationItem? designationItem;
  const CreateNewDesignationScreen({super.key, this.designationItem});

  @override
  State<CreateNewDesignationScreen> createState() => _CreateNewDesignationScreenState();
}

class _CreateNewDesignationScreenState extends State<CreateNewDesignationScreen> {

  @override
  Widget build(BuildContext context) {
    return Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeSmall),
      child: CreateNewDesignationWidget(designationItem: widget.designationItem,),
    );
  }
}
