import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_snackbar.dart';
import 'package:mighty_school/common/widget/custom_text_field.dart';
import 'package:mighty_school/common/widget/custom_title.dart';
import 'package:mighty_school/feature/staff_information/designation/controller/designation_controller.dart';
import 'package:mighty_school/feature/staff_information/designation/domain/models/designation_model.dart';
import 'package:mighty_school/util/dimensions.dart';

class CreateNewDesignationWidget extends StatefulWidget {
  final DesignationItem? designationItem;
  const CreateNewDesignationWidget({super.key, this.designationItem});

  @override
  State<CreateNewDesignationWidget> createState() => _CreateNewDesignationWidgetState();
}

class _CreateNewDesignationWidgetState extends State<CreateNewDesignationWidget> {
  TextEditingController designationTitleController = TextEditingController();
  bool update = false;
  @override
  void initState() {
    if(widget.designationItem != null){
      update = true;
      designationTitleController.text = widget.designationItem?.name??'';
      
    }
    super.initState();
  }
  @override
  Widget build(BuildContext context) {
    return Dialog(shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(Dimensions.radiusDefault)),
      child: GetBuilder<DesignationController>(
          builder: (designationController) {
            return Padding(
              padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
              child: Column(mainAxisSize: MainAxisSize.min, children: [
                const Padding(padding: EdgeInsets.symmetric(vertical: Dimensions.paddingSizeDefault),
                    child: CustomTitle(title: "add_new_designation")),

                CustomTextField(title: "designation".tr,
                  controller: designationTitleController,
                  hintText: "name".tr,),


                designationController.isLoading? const Padding(padding: EdgeInsets.all(Dimensions.paddingSizeDefault),
                    child: Center(child: CircularProgressIndicator())):

                Padding(padding: const EdgeInsets.symmetric(vertical: Dimensions.paddingSizeDefault),
                    child: CustomButton(onTap: (){

                      String designation = designationTitleController.text.trim();

                      if(designation.isEmpty){
                        showCustomSnackBar("designation_is_empty".tr);
                      }

                      else{
                        if(update){
                          designationController.updateDesignation(designation, widget.designationItem!.id!);
                        }else{
                          designationController.createNewDesignation(designation);
                        }

                      }
                    }, text: "confirm".tr))
              ],),
            );
          }
      ),
    );
  }
}
