@extends('layouts.backend')

@section('title', 'Dashboard')
@section('page_title', 'Dashboard')

@section('content')
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="card stat-card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1">Total Users</p>
                            <h3>1,234</h3>
                        </div>
                        <i class="bi bi-people text-primary" style="font-size: 2rem;"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h5>Sales Overview</h5>
        </div>
        <div class="card-body"><canvas id="salesChart"></canvas></div>
    </div>
@endsection

@push('scripts')
    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const ctx = document.getElementById("salesChart");
            new Chart(ctx, {
                type: "line",
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May"],
                    datasets: [{
                        label: "Sales",
                        data: [1200, 1900, 3000, 500, 2000],
                        borderWidth: 2
                    }]
                }
            });
        });
    </script>
@endpush
