<!DOCTYPE html>
<html lang="en">

<head>
    <base href="" />
    <title>@yield('title', config('app.name'))</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO -->
    <meta name="description" content="@yield('meta_description', '')" />
    <meta name="keywords" content="@yield('meta_keywords', '')" />
    <meta property="og:title" content="{{ config('app.name') }}" />

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ asset('backend_assets/media/logos/favicon.ico') }}" />
    <!-- Fonts -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />

    <!-- Core CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="{{ asset('DataTables/dataTables.bootstrap5.css') }}" rel="stylesheet" type="text/css" />

    <link rel="stylesheet" href="{{ asset('backend_assets/css/style.css') }}">
    @yield('styles')
</head>

<body>
    <div class="d-flex">
        <!-- Sidebar -->
        @include('layouts.includes.sidebar')

        <!-- Main Content -->
        <div class="main-content flex-grow-1">

            <!-- Header -->
            @include('layouts.includes.header')

            <!-- Dynamic Page Content -->
            <main class="container-fluid p-4">
                @yield('content')
            </main>

            <!-- Footer -->
            @include('layouts.includes.footer')
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>

    <!-- DataTables -->
    <script src="{{ asset('DataTables/dataTables.js') }}"></script>
    <script src="{{ asset('DataTables/dataTables.bootstrap5.js') }}"></script>

    <script src="{{ asset('backend_assets/js/theme.js') }}"></script>
    <script src="{{ asset('backend_assets/js/sidebar.js') }}"></script>

    @yield('scripts')
    <script>
        $(document).ready(function() {
            $(".data-table").DataTable({
                responsive: true,
                "bAutoWidth": false,
                "ordering": false,
                "pageLength": 50,
                "language": {
                    "decimal": "",
                    "emptyTable": "{{ 'No Data Found' }}",
                    "info": "{{ 'Showing' }} _START_ {{ 'to' }} _END_ {{ 'of' }} _TOTAL_ {{ 'Entries' }}",
                    "infoEmpty": "{{ 'Showing 0 To 0 Of 0 Entries' }}",
                    "infoFiltered": "(filtered from _MAX_ total entries)",
                    "infoPostFix": "",
                    "thousands": ",",
                    "lengthMenu": "{{ 'Show' }} _MENU_ {{ 'Entries' }}",
                    "loadingRecords": "{{ 'Loading...' }}",
                    "processing": "{{ 'Processing...' }}",
                    "search": "{{ 'Search' }}",
                    "zeroRecords": "{{ 'No matching records found' }}",
                    "paginate": {
                        "first": "{{ 'First' }}",
                        "last": "{{ 'Last' }}",
                        "next": "{{ 'Next' }}",
                        "previous": "{{ 'Previous' }}"
                    },
                    "aria": {
                        "sortAscending": ": activate to sort column ascending",
                        "sortDescending": ": activate to sort column descending"
                    }
                },
                dom: 'Blfrtip',
                buttons: [
                    // 'copy', 'csv', 'excel', 'pdf', 'print'
                ],
            });
        });
    </script>
</body>

</html>
